/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230516
* Description : 演示进入IDLE低功耗模式，并通过timer3定时溢出中断进行唤醒的功能。
*               进入IDLE模式之前，IO口PB2进行一定次数翻转，进入IDLE模式睡眠后，IO口PB2停止翻转；
*				timer3计数溢出时产生T3IF中断唤醒IDLE低功耗模式后，IO口PB2会再次进行翻转。
********************************************************************************/
#include "AD18F08.h"
#include <stdio.h>

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_OFF        :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL_LOW		    :  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _MTPDIS_OFF       ： SWD模式下读FLASH和EEPROM控位
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L      & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L      & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                     );


void main(void)
{
	unsigned char i;

	TRISB2=0;//PB2设为输出模式
	TRISA2=0;//PA2设为输出模式

	IPEN=1;//允许高低优先级中断
	GIEH=1;//使能高优先级中断
	PEIE=1;//使能低优先级中断
    TMR3IP=1;//tmr3设为高优先级中断
    TMR3IF=0;//tmr3中断状态初始化为0
    TMR3IE=1;//使能tmr3中断

    T3CLKEN=1; 	//使能tmr3时钟
	TMR3H=0X00; //
	TMR3L=0X60;	//tmr3初始化为0x60
	T3CON=0X7F;	//T3ON Fosc prediv16 postdiv16

	while(1)
	{
		for(i=0;i<20;i++)
		{
			PB2=~PB2;
			__delay_us(1000);
		}
		PB2=0;

		SLEEP_PWIDLE();//进入IDLE低功耗模式

	}
}


//中断服务函数
void interrupt ISR_h(void)
{
	if((TMR3IF==1)&&(TMR3IE==1))
	{
		TMR3IF=0;
		PA2=~PA2;
	}
}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}
